% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_indeces.R
\name{calc_simpson_index}
\alias{calc_simpson_index}
\title{Calculate the Simpson Diversity Index}
\usage{
calc_simpson_index(mf, magnitude)
}
\arguments{
\item{mf}{Character vector. A list of unique molecular formulas.}

\item{magnitude}{Numeric vector. A list of respective abundances (intensities) for each molecular formula.
Must be non-negative and have the same length as \code{mf}.}
}
\value{
A single numeric value representing the Simpson diversity index. Returns 0 if \code{magnitude} is all zeros.
}
\description{
The Simpson diversity index is calculated to measure the probability that two randomly selected individuals
(e.g., molecular formulas) belong to the same category. It quantifies the dominance or evenness within a dataset.

The Simpson index is defined as:
\deqn{D = \sum (p_i^2)}
where:
\itemize{
\item \eqn{p_i} is the relative abundance of the \eqn{i}-th molecular formula.
}

The index ranges between 0 and 1:
\itemize{
\item A value near 0 indicates high diversity (even distribution of abundances).
\item A value of 1 indicates no diversity (one molecular formula dominates).
}
}
\examples{
calc_simpson_index(
  mf = c("C10H20O5", "C12H18O3", "C18H30O6"),
  magnitude = c(1982375, 2424, 312410)
)
}
