% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_indeces.R
\name{calc_shannon_index}
\alias{calc_shannon_index}
\title{Calculate the Shannon Diversity Index}
\usage{
calc_shannon_index(mf, magnitude)
}
\arguments{
\item{mf}{Character vector. A list of unique molecular formulas.}

\item{magnitude}{Numeric vector. A list of respective abundances (intensities) for each molecular formula.
Must be non-negative and have the same length as \code{mf}.}
}
\value{
A single numeric value representing the Shannon diversity index. Returns 0 if \code{magnitude} is all zeros.
}
\description{
The Shannon diversity index is calculated to quantify the diversity of molecular formulas based on
their relative abundances. This index considers both the richness (number of unique formulas)
and the evenness (distribution of abundances). Higher values indicate greater diversity.

The Shannon index is defined as:
\deqn{H = -\sum (p_i \cdot \ln(p_i))}
where:
\itemize{
\item \eqn{p_i} is the relative abundance of the \eqn{i}-th molecular formula.
}

Zero-abundance formulas are excluded from the calculation.
}
\examples{
calc_shannon_index(
  mf = c("C10H20O5", "C12H18O3", "C18H30O6"),
  magnitude = c(1982375, 2424, 312410)
)
}
