% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_nm.R
\name{calc_nm}
\alias{calc_nm}
\title{Calculate Nominal Mass of a Molecule}
\usage{
calc_nm(mfd, ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A numeric vector of the calculated nominal mass.
}
\description{
Computes the nominal mass (integer mass) for each molecular formula in the provided data.
This function uses isotope masses stored in the dataset \code{ume::masses}, based on values from NIST,
for accurate calculation of each element's nominal mass contribution.
}
\details{
The function calculates the nominal mass of each molecular formula by retrieving the relevant
integer mass values of isotopes from \code{ume::masses}. This information is processed to create a calculation
string which is then evaluated to obtain the nominal mass for each molecule.

The nominal mass is derived by summing the integer masses of each constituent element in the formula,
where the integer mass for each element is multiplied by the number of atoms of that element in the molecule.

Note: This function depends on \code{ume::get_isotope_info()} for isotope data retrieval.
}
\examples{
# Example using a demo dataset to calculate nominal mass
calc_nm(mfd = mf_data_demo)
}
\seealso{
Other calculations: 
\code{\link{calc_data_summary}()},
\code{\link{calc_dbe}()},
\code{\link{calc_eval_params}()},
\code{\link{calc_exact_mass}()},
\code{\link{calc_ideg}()},
\code{\link{calc_ma}()},
\code{\link{calc_neutral_mass}()},
\code{\link{calc_norm_int}()},
\code{\link{calc_number_assignment}()},
\code{\link{calc_number_occurrence}()},
\code{\link{calc_recalibrate_ms}()}
}
\concept{calculations}
