% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweedie_plot.R
\name{tweedie_plot}
\alias{tweedie_plot}
\alias{tweedie.plot}
\title{Plot Tweedie Models}
\usage{
tweedie_plot(y, xi = NULL, mu, phi, type = "pdf", power = NULL, add = FALSE, ...)

tweedie.plot(
  y,
  xi = NULL,
  mu,
  phi,
  type = "pdf",
  power = NULL,
  add = FALSE,
  ...
)
}
\arguments{
\item{y}{the values for \eqn{y}{y} in the plot.}

\item{xi}{a synonym for \code{power}.}

\item{mu}{the mean of the distribution \eqn{\mu}{mu}.}

\item{phi}{the dispersion parameter \eqn{\phi}{phi}.}

\item{type}{the type of plot, either \code{PDF} (the default) or \code{CDF}.}

\item{power}{the variance power \eqn{p}{power}.}

\item{add}{logical; if \code{TRUE}, the plot is added to the current plot; if \code{FALSE} (the default) the plot is produced on a fresh plot.}

\item{...}{plotting parameters passed to \code{plot()}.}
}
\description{
This function produced a plot of the specified Tweedie distribution.
}
\details{
If \eqn{1 < p < 2}{1 < power < 2}, the mass at \eqn{Y=0}{Y = 0} is automatically added.
}
\examples{
y <- seq(0, 4, length = 50)
tweedie_plot(y, power = 1.1, mu = 1, phi = 1)


}
