% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtweedie_series.R
\name{dtweedie_series}
\alias{dtweedie_series}
\alias{dtweedie.series}
\title{Series Evaluation for the Tweedie Probability Function}
\usage{
dtweedie_series(y, power, mu,phi)

dtweedie.series(y, power, mu, phi)
}
\arguments{
\item{y}{vector of quantiles.}

\item{power}{scalar; the value of \eqn{p}{power} such that the variance is \eqn{\mbox{var}[Y]=\phi\mu^{p}}{var[Y] = phi * mu^power}.}

\item{mu}{vector of mean \eqn{\mu}{mu}.}

\item{phi}{vector of dispersion parameters \eqn{\phi}{phi}.}
}
\value{
A numeric vector of densities.
}
\description{
Evaluates the probability density function (\acronym{pdf}) for Tweedie distributions using an infinite series, 
for given values of the dependent variable \code{y}, the mean \code{mu}, dispersion \code{phi}, and power parameter \code{power}.
\emph{Not usually called by general users}, but can be used in the case of evaluation problems.
}
\examples{
# Plot a Tweedie density
y <- seq(0.01, 4, length = 50)
fy <- dtweedie_series(y, power = 1.1, mu = 1, phi = 1)
plot(y, fy, type = "l", lwd = 2, ylab = "Density")
}
\references{
Dunn, Peter K and Smyth, Gordon K (2005).
Series evaluation of Tweedie exponential dispersion model densities
\emph{Statistics and Computing},
\bold{15}(4). 267--280.
\doi{10.1007/s11222-005-4070-y}
}
\keyword{distribution}
