% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_registry.R
\name{list_vision_models}
\alias{list_vision_models}
\title{List Available Vision Models}
\usage{
list_vision_models(
  include_builtin = TRUE,
  architecture_filter = NULL,
  verbose = FALSE
)
}
\arguments{
\item{include_builtin}{Logical indicating whether to include built-in models
(default: TRUE)}

\item{architecture_filter}{Optional character vector to filter by architecture type}

\item{verbose}{Logical indicating whether to show detailed information
(default: FALSE)}
}
\value{
A data.frame with model information, or detailed list if verbose=TRUE
}
\description{
List all vision models currently available in the transforEmotion registry.
}
\examples{
# List all available models
list_vision_models()

# List only CLIP models
list_vision_models(architecture_filter = "clip")

# Get detailed information
list_vision_models(verbose = TRUE)

# See what models are available for image analysis
models <- list_vision_models()
print(paste("Available models:", paste(models$name, collapse = ", ")))
}
