#' Example road network datasets
#'
#' A collection of example road network datasets provided as `sf` objects.
#' These datasets are intended for demonstration, testing, and benchmarking.
#'
#' Each dataset contains LINESTRING road geometries suitable for use with
#' \code{roads_to_segments()} and related functions.
#'
#' @format An object of class \code{sf}.
#'
#' @details
#' Included datasets:
#' \describe{
#'   \item{roads_small}{Small example road network.}
#'   \item{roads_cstat}{Road network for College Station, TX.}
#' }
#'
#' @name roads_datasets
#' @aliases roads_small roads_cstat
#' @docType data
#' @keywords datasets
NULL
