% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation.R
\name{permutation_test}
\alias{permutation_test}
\alias{permutation_test.tna}
\title{Compare Two Networks from Sequence Data using a Permutation Test}
\usage{
permutation_test(x, ...)

\method{permutation_test}{tna}(
  x,
  y,
  adjust = "none",
  iter = 1000,
  paired = FALSE,
  level = 0.05,
  measures = character(0),
  ...
)
}
\arguments{
\item{x}{A \code{tna} object containing sequence data for the first \code{tna} model.}

\item{...}{Additional arguments passed to \code{\link[=centralities]{centralities()}}.}

\item{y}{A \code{tna} object containing sequence data for the second \code{tna} model.}

\item{adjust}{A \code{character} string for the method to adjust p-values with
for multiple comparisons. The default is \code{"none"} for no adjustment.
See the \code{method} argument of \code{\link[stats:p.adjust]{stats::p.adjust()}} for details and available
adjustment methods.}

\item{iter}{An \code{integer} giving the number of permutations to perform.
The default is 1000.}

\item{paired}{A \code{logical} value. If \code{TRUE}, perform paired permutation tests;
if \code{FALSE}, perform unpaired tests. The default is \code{FALSE}.}

\item{level}{A \code{numeric} value giving the significance level for the
permutation tests. The default is 0.05.}

\item{measures}{A \code{character} vector of centrality measures to test.
See \code{\link[=centralities]{centralities()}} for a list of available centrality measures.}
}
\value{
A \code{tna_permutation} object which is a \code{list} with two elements:
\code{edges} and \code{centralities}, both containing the following elements:
\itemize{
\item \code{stats}: A \code{data.frame} of original differences, effect sizes, and
estimated p-values for each edge or centrality measure. The effect size
is computed as the observed difference divided by the standard deviation
of the differences of the permuted samples.
\item \code{diffs_true}: A \code{matrix} of differences in the data.
\item \code{diffs_sig}: A \code{matrix} showing the significant differences.
}
}
\description{
This function compares two networks built from sequence data using
permutation tests. The function builds Markov models for two sequence
objects, computes the transition probabilities, and compares them by
performing permutation tests. It returns the differences in transition
probabilities, effect sizes, estimated p-values, and confidence intervals.
}
\examples{
model_x <- tna(group_regulation[1:200, ])
model_y <- tna(group_regulation[1001:1200, ])
# Small number of iterations for CRAN
permutation_test(model_x, model_y, iter = 20)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_reliability}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_clustering}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_reliability}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reliability}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
