% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-catboost.R
\name{set_catboost_categories}
\alias{set_catboost_categories}
\title{Set categorical feature mappings for CatBoost model}
\usage{
set_catboost_categories(parsed_model, model, data)
}
\arguments{
\item{parsed_model}{A parsed CatBoost model from \code{parse_model()}}

\item{model}{The original CatBoost model object}

\item{data}{A data frame containing factor columns matching the categorical
features used in the model. The factor levels must match those from
training.}
}
\value{
The parsed model with category mappings added
}
\description{
CatBoost stores categorical features as hash values internally. This function
establishes the mapping between hash values and category names by examining
a data frame with the same factor columns used during training.
}
\details{
This function is only needed when using raw CatBoost models (trained with
\code{catboost.train()}). When using parsnip/bonsai, categorical features are
handled automatically and this function is not required.
}
\examples{
\dontrun{
# For raw CatBoost models with categorical features:
pm <- parse_model(catboost_model)
pm <- set_catboost_categories(pm, catboost_model, training_data)
tidypredict_fit(pm)

# For parsnip/bonsai models, this is not needed:
# tidypredict_fit(parsnip_model_fit)  # works automatically
}
}
