% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-nested.R
\name{generate_nested_case_when_tree}
\alias{generate_nested_case_when_tree}
\title{Generate nested case_when trees}
\usage{
generate_nested_case_when_tree(tree_info)
}
\arguments{
\item{tree_info}{A tree info list from \code{rpart_tree_info_full()} or similar}
}
\description{
These functions generate nested \code{case_when()} expressions for decision trees,
which are more efficient than flat \code{case_when()} for both R/dplyr and SQL
execution.
}
\details{
The following tree:

\if{html}{\out{<div class="sourceCode">}}\preformatted{        +-----+
   +----|x > 0|----+
   |    +-----+    |
   v               v
}\if{html}{\out{</div>}}

+------+        +--------+
+--|y < 20|--+  +--|z <= 10 |--+
|  +------+  |  |  +--------+  |
v            v  v              v
a            b  c              d

will be turned into the following nested \code{case_when()} statement:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{case_when(
  x > 0 ~ case_when(
    y < 20 ~ "a",
    .default = "b"
  ),
  .default = case_when(
    z <= 10 ~ "c",
    .default = "d"
  )
)
}\if{html}{\out{</div>}}

NA values in predictor columns are not handled by the generated expression.
Users should ensure that predictor columns do not contain NA values before
using the generated expression, or the results will be NA for those rows.
}
\keyword{Generate}
\keyword{a}
\keyword{case_when}
\keyword{for}
\keyword{internal}
\keyword{nested}
\keyword{tree}
