% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_dapc_tidiers.R
\name{tidy.gt_dapc}
\alias{tidy.gt_dapc}
\alias{gt_dapc_tidiers}
\title{Tidy a \code{gt_dapc} object}
\usage{
\method{tidy}{gt_dapc}(x, matrix = "eigenvalues", ...)
}
\arguments{
\item{x}{A \code{gt_dapc} object (as returned by \code{\link[=gt_dapc]{gt_dapc()}}).}

\item{matrix}{Character specifying which component of the DAPC should be
tidied.
\itemize{
\item \code{"samples"}, \code{"scores"}, or \code{"x"}: returns information about
the map from the original space into the least discriminant axes.
\item \code{"v"}, \code{"rotation"}, \code{"loadings"} or \code{"variables"}: returns information
about the map from discriminant axes space back into the original space
(i.e. the genotype frequencies). Note that this are different from the
loadings linking to the PCA scores (which are available in the element
$loadings of the dapc object).
\item \code{"d"}, \code{"eigenvalues"} or \code{"lds"}: returns information about the
eigenvalues.
}}

\item{...}{Not used. Needed to match generic signature only.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with columns depending on the component of DAPC
being tidied.

If \code{"scores"} each row in the tidied output corresponds to the original
data in PCA space. The columns are:

\item{\code{row}}{ID of the original observation (i.e. rowname from original
data).}
\item{\code{LD}}{Integer indicating a principal component.}
\item{\code{value}}{The score of the observation for that particular principal
component. That is, the location of the observation in PCA space.}

If \code{matrix} is  \code{"loadings"}, each row in the tidied output corresponds to
information about the principle components in the original space. The
columns are:

\item{\code{row}}{The variable labels (colnames) of the data set on
which PCA was performed.}
\item{\code{LD}}{An integer vector indicating the principal component.}
\item{\code{value}}{The value of the eigenvector (axis score) on the
indicated principal component.}

If \code{"eigenvalues"}, the columns are:

\item{\code{LD}}{An integer vector indicating the discriminant axis.}
\item{\code{std.dev}}{Standard deviation (i.e. sqrt(eig/(n-1))) explained by
this DA (for compatibility with \code{prcomp}.}
\item{\code{cumulative}}{Cumulative variation explained by
principal components up to this component (note that this is NOT
phrased as a percentage of total variance, since many methods
only estimate a truncated SVD.}
}
\description{
This summarizes information about the components of a \code{gt_dapc} from the
\code{tidypopgen} package. The parameter \code{matrix} determines which element is
returned.
}
\examples{
#' # Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
lobsters <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Remove monomorphic loci and impute
lobsters <- lobsters \%>\% select_loci_if(loci_maf(genotypes) > 0)
lobsters <- gt_impute_simple(lobsters, method = "mode")

# Create PCA and run DAPC
pca <- gt_pca_partialSVD(lobsters)
populations <- as.factor(lobsters$population)
dapc_res <- gt_dapc(pca, n_pca = 6, n_da = 2, pop = populations)

# Tidy scores
tidy(dapc_res, matrix = "scores")

# Tidy eigenvalues
tidy(dapc_res, matrix = "eigenvalues")

# Tidy loadings
tidy(dapc_res, matrix = "loadings")

}
\seealso{
\code{\link[=gt_dapc]{gt_dapc()}} \code{\link[=augment.gt_dapc]{augment.gt_dapc()}}
}
