% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{split_plot}
\alias{split_plot}
\title{Split plot into multiple subplots}
\usage{
split_plot(
  plot,
  by = NULL,
  rows = NULL,
  cols = NULL,
  ncol = NULL,
  nrow = NULL,
  axes = "all",
  axis.titles = "all",
  scales = NULL,
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{by}{One variable that should be used for splitting.}

\item{rows, cols}{Two variables that should be used for splitting, representing rows and columns, respectively.}

\item{ncol, nrow}{The number of columns and rows per page. Only takes effect when using \code{by} to split by a single variable.}

\item{axes}{Determines which axes will be drawn in case of fixed scales.
When \code{"margins"}, axes will be drawn at the exterior margins. \code{"all_x"} and \code{"all_y"} will draw
the respective axes at the interior panels too, whereas \code{"all"} (the default) will draw all axes at all panels.}

\item{axis.titles}{Determines which axis titles will be drawn.
When \code{"margins"}, axis titles will be drawn at the exterior margins. \code{"all"} (the default) will draw all axis titles at all panels.
\code{"single"} will draw a single axis title per multiplot layout.}

\item{scales}{Should scales be fixed \code{"fixed"}, free (\code{"free"}), or free in one dimension (\code{"free_x"}, \code{"free_y"})?
Defaults to \code{"free"} when providing one splitting variable via \code{by}.
Defaults to \code{"fixed"} when providing two splitting variables via \code{rows} and \code{cols}.}

\item{...}{Arguments passed on to the \code{geom} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
Split plot into multiple subplots
}
\examples{
# Before splitting
energy |>
  dplyr::filter(year \%in\% c(2005, 2010, 2015, 2020)) |>
  tidyplot(y = energy, color = energy_source) |>
  add_donut() |>
  adjust_size(width = 25, height = 25)

# Split by year
energy |>
  dplyr::filter(year \%in\% c(2005, 2010, 2015, 2020)) |>
  tidyplot(y = energy, color = energy_source) |>
  add_donut() |>
  adjust_size(width = 25, height = 25) |>
  split_plot(by = year)

# Change dimensions of subplots
energy |>
  dplyr::filter(year \%in\% c(2005, 2010, 2015, 2020)) |>
  tidyplot(y = energy, color = energy_source) |>
  add_donut() |>
  adjust_size(width = 15, height = 15) |>
  split_plot(by = year)

# Spread plots across multiple pages
energy |>
  dplyr::filter(year \%in\% c(2005, 2010, 2015, 2020)) |>
  tidyplot(y = energy, color = energy_source) |>
  add_donut() |>
  adjust_size(width = 25, height = 25) |>
  split_plot(by = year, ncol = 2, nrow = 1)

# Split by two variables
energy |>
  dplyr::mutate(decade = paste0(floor(year / 10) * 10, "s")) |>
  tidyplot(y = energy, color = energy_source) |>
  add_donut() |>
  adjust_size(14,14) |>
  split_plot(rows = decade, cols = energy_type)

}
