% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{design}
\alias{design}
\title{Extract design matrix}
\usage{
design(
  formula,
  data,
  ...,
  intercept = FALSE,
  response = TRUE,
  rm_envir = FALSE,
  specials = NULL,
  specials.call = NULL,
  levels = NULL,
  design.matrix = TRUE
)
}
\arguments{
\item{formula}{formula}

\item{data}{data.frame}

\item{...}{additional arguments (e.g, specials such weights, offsets, ...)}

\item{intercept}{(logical) If FALSE an intercept is not included in the
design matrix}

\item{response}{(logical) if FALSE the response variable is dropped}

\item{rm_envir}{Remove environment}

\item{specials}{character vector specifying functions in the formula that
should be marked as special in the \link{terms} object}

\item{specials.call}{(call) specials optionally defined as a call-type}

\item{levels}{a named list of character vectors giving the full set of levels
to be assumed for each factor}

\item{design.matrix}{(logical) if FALSE then only response and specials are
returned. Otherwise, the design.matrix \code{x} is als part of the returned
object.}
}
\value{
An object of class 'design'
}
\description{
Extract design matrix from data.frame and formula
}
\author{
Klaus Kähler Holst
}
