% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparam.R
\name{spa}
\alias{spa}
\title{Estimate frequency response}
\usage{
spa(x, winsize = NULL, freq = NULL)
}
\arguments{
\item{x}{an \code{idframe} object}

\item{winsize}{lag size of the Hanning window (Default: \code{min
(length(x)/10,30)})}

\item{freq}{frequency points at which the response is evaluated
(Default: \code{seq(1,128)/128*pi/Ts})}
}
\value{
an \code{idfrd} object containing the estimated frequency response 
and the noise spectrum
}
\description{
Estimates frequency response and noise spectrum from data with 
fixed resolution using spectral analysis
}
\examples{
data(arxsim)
frf <- spa(arxsim)

}
\references{
Arun K. Tangirala (2015), \emph{Principles of System Identification: 
Theory and Practice}, CRC Press, Boca Raton. Sections 16.5 and 20.4
}

