% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{ForestModel}
\alias{ForestModel}
\title{Forest Model C++ Wrapper}
\description{
Wraps the C++ data structures needed to sample an ensemble of decision
trees and exposes functionality to run a forest sampler
(using either MCMC or the grow-from-root algorithm).

This class is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{tracker_ptr}}{External pointer to a C++ ForestTracker class}

\item{\code{tree_prior_ptr}}{External pointer to a C++ TreePrior class}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ForestModel-new}{\code{ForestModel$new()}}
\item \href{#method-ForestModel-sample_one_iteration}{\code{ForestModel$sample_one_iteration()}}
\item \href{#method-ForestModel-get_cached_forest_predictions}{\code{ForestModel$get_cached_forest_predictions()}}
\item \href{#method-ForestModel-propagate_basis_update}{\code{ForestModel$propagate_basis_update()}}
\item \href{#method-ForestModel-propagate_residual_update}{\code{ForestModel$propagate_residual_update()}}
\item \href{#method-ForestModel-update_alpha}{\code{ForestModel$update_alpha()}}
\item \href{#method-ForestModel-update_beta}{\code{ForestModel$update_beta()}}
\item \href{#method-ForestModel-update_min_samples_leaf}{\code{ForestModel$update_min_samples_leaf()}}
\item \href{#method-ForestModel-update_max_depth}{\code{ForestModel$update_max_depth()}}
\item \href{#method-ForestModel-get_alpha}{\code{ForestModel$get_alpha()}}
\item \href{#method-ForestModel-get_beta}{\code{ForestModel$get_beta()}}
\item \href{#method-ForestModel-get_min_samples_leaf}{\code{ForestModel$get_min_samples_leaf()}}
\item \href{#method-ForestModel-get_max_depth}{\code{ForestModel$get_max_depth()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-new"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-new}{}}}
\subsection{Method \code{new()}}{
Create a new ForestModel object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$new(
  forest_dataset,
  feature_types,
  num_trees,
  n,
  alpha,
  beta,
  min_samples_leaf,
  max_depth = -1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_dataset}}{\code{ForestDataset} object, used to initialize forest sampling data structures}

\item{\code{feature_types}}{Feature types (integers where 0 = numeric, 1 = ordered categorical, 2 = unordered categorical)}

\item{\code{num_trees}}{Number of trees in the forest being sampled}

\item{\code{n}}{Number of observations in \code{forest_dataset}}

\item{\code{alpha}}{Root node split probability in tree prior}

\item{\code{beta}}{Depth prior penalty in tree prior}

\item{\code{min_samples_leaf}}{Minimum number of samples in a tree leaf}

\item{\code{max_depth}}{Maximum depth that any tree can reach}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ForestModel} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-sample_one_iteration"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-sample_one_iteration}{}}}
\subsection{Method \code{sample_one_iteration()}}{
Run a single iteration of the forest sampling algorithm (MCMC or GFR)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$sample_one_iteration(
  forest_dataset,
  residual,
  forest_samples,
  active_forest,
  rng,
  forest_model_config,
  global_model_config,
  num_threads = -1,
  keep_forest = TRUE,
  gfr = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_dataset}}{Dataset used to sample the forest}

\item{\code{residual}}{Outcome used to sample the forest}

\item{\code{forest_samples}}{Container of forest samples}

\item{\code{active_forest}}{"Active" forest updated by the sampler in each iteration}

\item{\code{rng}}{Wrapper around C++ random number generator}

\item{\code{forest_model_config}}{ForestModelConfig object containing forest model parameters and settings}

\item{\code{global_model_config}}{GlobalModelConfig object containing global model parameters and settings}

\item{\code{num_threads}}{Number of threads to use in the GFR and MCMC algorithms, as well as prediction. If OpenMP is not available on a user's system, this will default to \code{1}, otherwise to the maximum number of available threads.}

\item{\code{keep_forest}}{(Optional) Whether the updated forest sample should be saved to \code{forest_samples}. Default: \code{TRUE}.}

\item{\code{gfr}}{(Optional) Whether or not the forest should be sampled using the "grow-from-root" (GFR) algorithm. Default: \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-get_cached_forest_predictions"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-get_cached_forest_predictions}{}}}
\subsection{Method \code{get_cached_forest_predictions()}}{
Extract an internally-cached prediction of a forest on the training dataset in a sampler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$get_cached_forest_predictions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Vector with as many elements as observations in the training dataset
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-propagate_basis_update"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-propagate_basis_update}{}}}
\subsection{Method \code{propagate_basis_update()}}{
Propagates basis update through to the (full/partial) residual by iteratively
(a) adding back in the previous prediction of each tree, (b) recomputing predictions
for each tree (caching on the C++ side), (c) subtracting the new predictions from the residual.

This is useful in cases where a basis (for e.g. leaf regression) is updated outside
of a tree sampler (as with e.g. adaptive coding for binary treatment BCF).
Once a basis has been updated, the overall "function" represented by a tree model has
changed and this should be reflected through to the residual before the next sampling loop is run.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$propagate_basis_update(dataset, outcome, active_forest)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{\code{ForestDataset} object storing the covariates and bases for a given forest}

\item{\code{outcome}}{\code{Outcome} object storing the residuals to be updated based on forest predictions}

\item{\code{active_forest}}{"Active" forest updated by the sampler in each iteration}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-propagate_residual_update"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-propagate_residual_update}{}}}
\subsection{Method \code{propagate_residual_update()}}{
Update the current state of the outcome (i.e. partial residual) data by subtracting the current predictions of each tree.
This function is run after the \code{Outcome} class's \code{update_data} method, which overwrites the partial residual with an entirely new stream of outcome data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$propagate_residual_update(residual)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{residual}}{Outcome used to sample the forest}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-update_alpha"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-update_alpha}{}}}
\subsection{Method \code{update_alpha()}}{
Update alpha in the tree prior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$update_alpha(alpha)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{New value of alpha to be used}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-update_beta"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-update_beta}{}}}
\subsection{Method \code{update_beta()}}{
Update beta in the tree prior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$update_beta(beta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beta}}{New value of beta to be used}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-update_min_samples_leaf"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-update_min_samples_leaf}{}}}
\subsection{Method \code{update_min_samples_leaf()}}{
Update min_samples_leaf in the tree prior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$update_min_samples_leaf(min_samples_leaf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min_samples_leaf}}{New value of min_samples_leaf to be used}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-update_max_depth"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-update_max_depth}{}}}
\subsection{Method \code{update_max_depth()}}{
Update max_depth in the tree prior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$update_max_depth(max_depth)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{max_depth}}{New value of max_depth to be used}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-get_alpha"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-get_alpha}{}}}
\subsection{Method \code{get_alpha()}}{
Update alpha in the tree prior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$get_alpha()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of alpha in the tree prior
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-get_beta"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-get_beta}{}}}
\subsection{Method \code{get_beta()}}{
Update beta in the tree prior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$get_beta()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of beta in the tree prior
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-get_min_samples_leaf"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-get_min_samples_leaf}{}}}
\subsection{Method \code{get_min_samples_leaf()}}{
Query min_samples_leaf in the tree prior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$get_min_samples_leaf()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of min_samples_leaf in the tree prior
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModel-get_max_depth"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModel-get_max_depth}{}}}
\subsection{Method \code{get_max_depth()}}{
Query max_depth in the tree prior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModel$get_max_depth()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of max_depth in the tree prior
}
}
}
