% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSM.R
\name{.ssm}
\alias{.ssm}
\title{SSM per sound}
\usage{
.ssm(
  audio,
  sparse = FALSE,
  input = c("melspec", "mfcc", "spec", "audSpec")[1],
  melfcc_pars = list(windowLength = 125, step = 25, nbands = 50),
  MFCC = 2:13,
  audSpec_pars = list(nFilters = 16, step = 10),
  takeLog = FALSE,
  norm = FALSE,
  simil = c("cosine", "cor")[1],
  kernelLen = 100,
  kernelSD = 0.5,
  padWith = 0,
  win = 1,
  output = c("ssm", "novelty", "summary"),
  plot = TRUE,
  main = NULL,
  heights = c(2, 1),
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  specPars = list(colorTheme = c("bw", "seewave", "heat.colors", "...")[2], xlab =
    "Time, s", ylab = "kHz"),
  ssmPars = list(colorTheme = c("bw", "seewave", "heat.colors", "...")[2], xlab =
    "Time, s", ylab = "Time, s"),
  noveltyPars = list(type = "b", pch = 16, col = "black", lwd = 3)
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{sparse}{if TRUE, the entire SSM is not calculated, but only the central
region needed to extract the novelty contour (speeds up the processing)}

\item{input}{the spectral representation used to calculate the SSM: "audSpec"
= auditory spectrogram returned by \code{\link{audSpectrogram}}, "mfcc" =
Mel-Frequency Cepstral coefficients, "melspec" = Mel-transformed STFT
spectrogram, "spec" = STFT power spectrogram (all three returned by
\code{\link[tuneR]{melfcc}}). Any custom spectrogram-like matrix of
features (time in columns labeled in s, features in rows) is also accepted
(see examples)}

\item{melfcc_pars}{a list of parameters passed to \code{\link[tuneR]{melfcc}}}

\item{MFCC}{which mel-frequency cepstral coefficients to use; defaults to
\code{2:13}}

\item{audSpec_pars}{a list of parameters passed to
\code{\link{audSpectrogram}} (if input = 'audSpec')}

\item{takeLog}{if TRUE, the input is log-transformed prior to calculating
self-similarity}

\item{norm}{if TRUE, the spectrum of each STFT frame is normalized}

\item{simil}{method for comparing frames: "cosine" = cosine similarity, "cor"
= Pearson's correlation}

\item{kernelLen}{length of checkerboard kernel for calculating novelty, ms
(larger values favor global, slow vs. local, fast novelty)}

\item{kernelSD}{SD of checkerboard kernel for calculating novelty}

\item{padWith}{how to treat edges when calculating novelty: NA = treat sound
before and after the recording as unknown, 0 = treat it as silence}

\item{output}{what to return (drop "ssm" to save memory when analyzing a lot
of files)}

\item{plot}{if TRUE, plots the SSM}

\item{main}{plot title}

\item{heights}{relative sizes of the SSM and spectrogram/novelty plot}

\item{width, height, units, res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{specPars}{graphical parameters passed to \code{filled.contour.mod} and
affecting the \code{\link{spectrogram}}}

\item{ssmPars}{graphical parameters passed to \code{filled.contour.mod} and
affecting the plot of SSM}

\item{noveltyPars}{graphical parameters passed to
\code{\link[graphics]{lines}} and affecting the novelty contour}
}
\description{
Internal soundgen function.
}
\keyword{internal}
