% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Levenetests2s.mv.R
\name{Levenetests2s.mv}
\alias{Levenetests2s.mv}
\title{Multiple two-sample Levene tests for the comparison of variation in
multivariate data}
\usage{
Levenetests2s.mv(
  x,
  group,
  level1,
  alternative = "two.sided",
  var.equal = FALSE,
  P.adjust = "none",
  unit = "units"
)
}
\arguments{
\item{x}{a data frame with one two-level factor and \emph{p} response
variables.}

\item{group}{two-level factor defining groups. It must be one of the columns
in \code{x}.}

\item{level1}{a character string identifying Sample 1. The string must be one
of the factor levels in \code{group}.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or
\code{"less"}. You can specify just the initial letter.}

\item{var.equal}{a logical variable indicating whether to treat the two
variances as being equal. If \code{TRUE} then the pooled variance is used to
estimate the variance otherwise the Welch (or Satterthwaite) approximation to
the degrees of freedom is used.}

\item{P.adjust}{p-value correction method, a character string. Can be
abbreviated. See 'Details'.}

\item{unit}{Physical units of the response variable useful to fully
characterize raw effect sizes}
}
\value{
Returns an object of class \code{"Levenetests2s.mv"}, a list containing the
following components:
\tabular{lllllllll}{
\code{ name} \tab A character string describing the function. \cr
\code{medians} \tab A list containing two vectors of length \emph{p},
being \emph{p} the number of response variables. \code{medians1} and
\code{medians2} store the medians for samples 1 (corresponding to
\code{level1}) and 2, respectively.  \cr
\code{absdev.median} \tab A list containing two data frames,
\code{abs.dev.median1} and \code{abs.dev.median2}, corresponding to the
absolute deviation around sample medians 1 and 2, respectively \cr
\code{means.absdev} \tab A list containing two vectors of length \emph{p},
(\code{means.absdev1} and \code{means.absdev1}), corresponding to the
mean absolute deviations around medians for variables 1,...,\emph{p}, in
samples 1 and 2, respectively. \cr
\code{vars.absdev} \tab A list containing two vectors of length \emph{p},
(\code{vars.absdev1} and \code{vars.absdev1}), corresponding to the
variances of absolute deviations around medians for variables 1,...,
\emph{p}, in samples 1 and 2, respectively. \cr
\code{t.list} \tab A list containing \emph{p} vectors of length 5, each
vector containing the t-statistic, the degrees of freedom, the adjusted
p-value for the test, the raw effect size estimator:
\eqn{\bar{x}_1 - \bar{x}_2}, and the post hoc effect size estimator
recommended by Hedges (1981), analogous to Cohen's \emph{d}, given by
\eqn{|\bar{x}_1 - \bar{x}_2| / \hat{\sigma}}. Here
\eqn{\hat{\sigma} = \sqrt{MSE}} where \eqn{MSE} is the mean squared error,
the estimator of the variance for the difference of means
\eqn{\bar{x}_1 - \bar{x}_2}, respectively. \cr
\code{alternative} \tab A character string specifying the alternative
hypothesis chosen. \cr
\code{var.equal} \tab A logical variable indicating whether the two
variances were treated as being equal \code{TRUE} or not \code{FALSE}.
\cr
\code{P.adjust} \tab A character string indicating the correction method
chosen \cr
\code{group} \tab A character string specifying the name of the two-level
factor defining groups. \cr
\code{levels.group} \tab a vector of length two showing the two levels in
factor \code{group}. \cr
\code{data.name} \tab a character string giving the name of the data. \cr
\code{data} \tab the data frame analyzed. \cr
}

The extractor function \code{\link[smsets]{print.Levenetests2s.mv}} returns an
annotated output of the Levene tests (or, equivalently, the two-sample
t-tests applied to the absolute differences around medians).
}
\description{
Performs multiple two-sample Levene tests, based on two-sample t-tests
applied to absolute differences around medians for more than one response
vector, with corrected significance levels using any of the adjustment
methods for multiple comparisons offered by \code{\link[stats]{p.adjust}}.
This function includes the argument \code{alternative =} useful to specify
the type of alternative, either one-sided (lower-/ upper-tail) or two-sided.
Effects sizes are also computed with respect to the two-sample t-tests.
}
\details{
This function focuses on the univariate Levene test for the comparison of
mean values for two samples, when more than one variable is involved in the
data analysis, so that type one error rates ("false significances") in the
series of Levene tests are adjusted according to the number of response
variables analyzed. The pairwise comparisons between the two levels in
\code{group} with corrections for multiple testing are made over more than
one response vector.

The methods implemented in \code{P.adjust} are the same as those contained in
the \code{p.adjust.methods}: \code{"bonferroni"}, \code{"holm"},
\code{"hochberg"}, \code{"hommel"}, \code{"BH"}, (Benjamini-Hochberg) or its
alias \code{"fdr"} (False Discovery Rate), and \code{"BY"} (Benjamini &
Yekutieli). The default pass-through option (\code{"none"}) is also included.
}
\examples{
data(sparrows)
res.Levene2s.mv <- Levenetests2s.mv(sparrows, Survivorship, "S",
                                alternative = "less", var.equal = TRUE,
                                P.adjust = "bonferroni", unit = "mm")
res.Levene2s.mv

}
\references{
Manly, B.F.J., Navarro Alberto, J.A. and Gerow, K. (2024)
\emph{Multivariate Statistical Methods. A Primer}. 5th Edn.
Chapman and Hall/CRC.

Hedges, L. V. 1981. Distribution theory for Glass’s estimator of effect size
and related estimators. \emph{Journal of Educational Statistics} 6(2): 107–128.
}
\author{
Jorge Navarro Alberto, \email{ganava4@gmail.com}
}
