#' sffdr: Surrogate Functional False Discovery Rate
#'
#' @description
#' Estimate functional p-values, q-values, and local false discovery rates
#' for GWAS data using summary statistics of related traits. The surrogate functional FDR
#' (sfFDR) methodology extends the functional FDR framework to leverage
#' informative covariates (e.g., functional annotations,  GWAS
#' summary statistics) for increased power while controlling false discovery
#' rates.
#'
#' @section Main Functions:
#' \describe{
#'   \item{\code{\link{pi0_model}}}{Build spline model for functional pi0 with adaptive knot selection}
#'   \item{\code{\link{fpi0est}}}{Estimate functional pi0 using GLM with constrained binomial}
#'   \item{\code{\link{sffdr}}}{Compute functional p-values, q-values, and local FDRs}
#'   \item{\code{\link{plot.sffdr}}}{Visualize sfFDR results}
#' }
#'
#' @section Workflow:
#' \enumerate{
#'   \item Prepare informative variables (i.e., p-values from related GWAS)
#'   \item Build functional pi0 model: \code{mpi0 <- pi0_model(z)}
#'   \item Estimate functional pi0: \code{fpi0 <- fpi0est(p, z = mpi0$zt, pi0_model = mpi0$fmod)}
#'   \item Apply sfFDR: \code{sffdr_out <- sffdr(p, fpi0 = fpi0$fpi0)}
#'   \item Visualize: \code{plot(sffdr_out)}
#' }
#'
#' @author Andrew J. Bass
#'
#' @seealso
#' \code{\link{pi0_model}}, \code{\link{fpi0est}}, \code{\link{sffdr}}, \code{\link{plot.sffdr}}
#'
#' @docType package
#' @name sffdr-package
#' @aliases sffdr-package
#' @keywords internal
"_PACKAGE"
