% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCBI.R
\name{download_genbank}
\alias{download_genbank}
\title{download_genbank}
\usage{
download_genbank(acc, db = "nuccore", format = "genbank", outfile = NULL)
}
\arguments{
\item{acc}{accession number(s)}

\item{db}{supported db, currently 'nuccore'}

\item{format}{one of 'genbank' or 'fasta'}

\item{outfile}{output file, by default, acc.gb or acc.fa}
}
\value{
output file vector
}
\description{
download genbank or fasta file by accession number
}
\examples{
\dontrun{
tmpgb <- tempfile(fileext = '.gb')
tmpfa <- tempfile(fileext = '.fa')
download_genbank(acc='AB115403', format='genbank', outfile=tmpgb)
download_genbank(acc='AB115403', format='fasta', outfile=tmpfa)
}
}
\author{
Guangchuang Yu
}
