% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miPowerFit.R
\name{epcEquivCheck}
\alias{epcEquivCheck}
\title{EPC Equivalence Feasibility Check for Standardized Parameters}
\usage{
epcEquivCheck(lavaanObj, minRelEffect = 0.75, stdLoad = 0.4, cor = 0.1,
  corLatent = NULL, corResidual = NULL, stdBeta = 0.1)
}
\arguments{
\item{lavaanObj}{A fitted \code{lavaan} object representing the target model.}

\item{minRelEffect}{A scalar in (0, 1) specifying the minimum relative
magnitude of the standardized perturbation to be evaluated. The
default value of 0.75 indicates that perturbations equal to 75\\% of
the SESOI are treated as trivial. If EPCs exceed the SESOI under
such perturbations, EPC equivalence testing is not recommended.}

\item{stdLoad}{Standardized factor loading used to define the SESOI
for loading misspecifications.}

\item{cor}{Standardized correlation used as a default SESOI for
covariance misspecifications. This value is used for both latent
and residual covariances unless overridden by
\code{corLatent} or \code{corResidual}.}

\item{corLatent}{Standardized latent factor correlation used to
define the SESOI for latent covariance misspecifications. If
\code{NULL}, defaults to \code{cor}.}

\item{corResidual}{Standardized residual correlation used to define
the SESOI for indicator residual covariance misspecifications. If
\code{NULL}, defaults to \code{cor}.}

\item{stdBeta}{Standardized regression coefficient used to define
the SESOI for structural misspecifications.}
}
\value{
An object of class \code{"epcEquivCheckStd"} containing:
\itemize{
\item \code{feasible}: Logical indicator of whether a valid
standardized population model exists.
\item \code{any_M}: Logical indicator of whether any EPC exceeded
the SESOI under the evaluated misspecifications.
\item \code{recommendation}: Character string summarizing feasibility
(e.g., \code{"RECOMMENDED"}, \code{"NOT RECOMMENDED"}).
\item \code{M_table}: Data frame summarizing EPCs exceeding the SESOI,
if any.
\item \code{testeffect}: Data frame reporting the smallest tested
standardized perturbations in each direction.
}
}
\description{
Performs an EPC-based feasibility check to assess whether a set of
standardized population parameters defines a valid population
covariance matrix and whether trivially misspecified parameters
remain within a user-defined smallest effect size of interest (SESOI).
Feasibility is evaluated by constructing implied population models
under targeted parameter perturbations and examining EPC behavior
using \code{\link{epcEquivFit}}.
}
\details{
This function focuses on standardized parameters and supports
recursive SEMs with continuous indicators only.

The procedure first checks whether the standardized parameters imply
a positive definite population covariance matrix. It then evaluates
EPC behavior under both positive and negative trivial
misspecifications by repeatedly constructing implied population
covariance matrices with perturbed parameters
(\code{minRelEffect} \eqn{\times} SESOI), refitting the model, and
re-evaluating EPCs.

Models with categorical indicators, formative indicators, or
multiple-group structures are not supported.
}
\examples{

library(lavaan)

one.model <- ' onefactor  =~ x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8 + x9 '
fit <- cfa(one.model, data = HolzingerSwineford1939)
\donttest{
epcEquivCheck(fit)
}

}
\seealso{
\code{\link{epcEquivFit}}
}
