% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{replicate_df}
\alias{replicate_df}
\title{Replicate a prediction data frame over time}
\usage{
replicate_df(dat, time_name, time_values)
}
\arguments{
\item{dat}{Data frame.}

\item{time_name}{Name of time column in output.}

\item{time_values}{Time values to replicate \code{dat} over.}
}
\value{
A data frame replicated over \code{time_values} with a new column based on
\code{time_name}.
}
\description{
Useful for replicating prediction grids across time slices used in model
fitting.
}
\examples{

df <- data.frame(variable = c("a", "b"))
replicate_df(df, time_name = "year", time_values = 1:3)

head(qcs_grid)
nd <- replicate_df(qcs_grid, "year", unique(pcod$year))
head(nd)
table(nd$year)
}
