% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-eegdata.R
\docType{data}
\name{eeg_data}
\alias{eeg_data}
\title{EEG Signals}
\format{
A data frame with columns:
\describe{
\item{index    }{Integer index of the measurement (frequency of 250 Hz).}
\item{condition}{Can take four values: \code{"initial_rest"}, devtools::document()
\code{"first_frontal_tDCS"}, \code{"second_frontal_tDCS"},
\code{"posterior_tDCS"}.}
\item{signal   }{Numeric EEG measurement.}
}
}
\source{
Original: Alexis Pomares, "Dissertation preprocessed EEG dataset",
\url{https://www.kaggle.com/datasets/alexispomares/dissertation-preprocessed}
This version has been preprocessed by selecting specific conditions and
removing outliers, for details see (Nadin, Kivobokova, Enikeeva; 2026).
}
\usage{
eeg_data
}
\description{
A dataset containing four EEG recordings of a patient under rest or different
transcranial Direct Current Stimulations (tDCS).
}
\examples{
data(eeg_data)
head(eeg_data)
tail(eeg_data)
str(eeg_data)
X1 <- subset(eeg_data, condition == "first_frontal_tDCS")$signal
}
\keyword{datasets}
