% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background_panel.R
\name{set_background}
\alias{set_background}
\alias{set_panel}
\title{Set plot and panel background of an scplot object}
\usage{
set_background(object, ...)

set_panel(object, ...)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{...}{List with rectangle parameters (\verb{"fill", "colour", "linewidth", "linetype"}). See \code{\link[=element_rect]{element_rect()}}.}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}).
}
\description{
The \code{set_background()} function allows you to customize the plot background
of an \code{scplot} object by specifying parameters such as fill color, border color,
line width, and line type. Similarly, the \code{set_panel()} function enables you
to set the panel background with the same customizable parameters. These
functions enhance the visual appearance of your plots by allowing you to
tailor the background styles to your preferences.
}
\examples{
data(exampleAB, package = "scan")
p1 <- scplot(exampleAB)  |>
 set_background(fill = "lightblue", colour = "darkblue", linewidth = 1.5) |>
 set_panel(fill = "deepskyblue", color = "darkblue", linewidth = 0.3)
}
