% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_statline.R
\name{add_statline}
\alias{add_statline}
\title{Add a statline to an scplot object}
\usage{
add_statline(
  object,
  stat = c("mean", "median", "min", "max", "quantile", "sd", "mad", "trend", "trendA",
    "trendA theil-sen", "trendA bisplit", "trendA trisplit", "moving mean",
    "moving median", "loreg", "lowess", "loess"),
  phase = NULL,
  color = NULL,
  linewidth = NULL,
  linetype = NULL,
  variable = NULL,
  label = NULL,
  ...
)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{stat}{A character string for defining a statistical line or curve to be
plotted. Possible values are \code{"mean"}, \code{"median"}, \code{"min"}, \code{"max"},
\code{"quantile"}, \code{"sd"}, \code{"mad"}, \code{"trend"}, \code{"trendA"}, \code{"trendA theil-sen"},
\code{"trendA bisplit"}, \code{"trendA trisplit"}, \code{"moving mean"},
\code{"moving median"}, \code{"loreg"} (local regression using \code{loess}), and
\code{"lowess"} (local regression using \code{lowess}).}

\item{phase}{Either a numeric or a character vector specifying the reference
phase (see details).}

\item{color}{A character string or a number defining the color of an element.}

\item{linewidth}{A number with the width of the line.}

\item{linetype}{A character string with the line type: \verb{"solid", "dashed", "dotted"}}

\item{variable}{Name of the dataline variable to apply the style.}

\item{label}{A character string which is used to set the label in a legend.}

\item{...}{additional parameters passed to the statistical function.}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}) with changed element
\code{statlines}.
}
\description{
This function adds a statistical line or curve to an existing \code{scplot}
object. Various statistical functions are available such as mean, median,
min, max, quantile, standard deviation, moving average, and trend lines.
}
\details{
The \code{phase} argument defines the reference phase for some
statistical functions (\verb{"median", "mean", "min", "max", "quantile"}). The
default is \code{NULL} which calculates and plots statistics for each phase
separately. The arguments takes a numeric vector (phase number(s)) or a
character vector (phase name(s)). When more than one phase is defines,
statistics are based on the combined values of these phases. Various
methods for an extrapolated \emph{trendA} line exist: \code{"trendA"} is based on an
OLS regression, \code{"trendA theil-sen"} on a nonparametric regression, and
\code{"trendA bisplit"} / \code{"trendA trisplit"} are two median based approaches.
Some of the functions defined in \code{stats} have additional arguments. The
\code{\link[=mean]{mean()}} function has a trim argument (e.g. \code{trim = 0.1}). \code{\link[=quantile]{quantile()}} has
a proportion argument (e.g. \code{prob = 0.75} for calculating the 75\%
quantile). \verb{moving mean} and \verb{moving median} have a lag argument (e.g. \code{lag = 2}). The local-regression curve function \code{"lowess"} (or \code{"loreg"}) has a
proportion argument (e.g. \code{f = 0.5}; see \code{\link[=lowess]{lowess()}}) and the
local-regression curve function \code{"loess"} has a span argument (e.g. \code{span = 0.75}; see \code{\link[=loess]{loess()}}).
}
