% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{load_pbp}
\alias{load_pbp}
\title{Load cleaned play-by-play data form the volleydata repository.}
\usage{
load_pbp(league = NULL, seasons = NULL)
}
\arguments{
\item{league}{A string specifying which of "mlv", "lovb", or "au" to load data for.}

\item{seasons}{An integer or vector of integers of seasons to fetch data for. Defaults to all available seasons.}
}
\value{
A data frame containing the play-by-play data for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   match_id \tab int \cr
   season \tab int \cr
   match_datetime \tab chr \cr
   home_team_name \tab chr \cr
   away_team_name \tab chr \cr
   team_involved \tab chr \cr
   jersey_number \tab int \cr
   action \tab chr \cr
   outcome \tab chr \cr
   set \tab int \cr
   point_number \tab int \cr
   point_winner \tab chr \cr
   home_score \tab int \cr
   away_score \tab int \cr
   rally_length \tab int \cr
}
}
\description{
Load cleaned play-by-play data form the volleydata repository.
}
\examples{
\donttest{try({load_pbp("mlv", 2024)})}
}
