% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R
\name{import_template}
\alias{import_template}
\title{Import a template into a project}
\usage{
import_template(
  project_id = get_project_id(project_name = project_name, token = token, create = FALSE),
  project_name,
  file_path,
  verbose = TRUE,
  token = get_todoist_api_token()
)
}
\arguments{
\item{project_id}{id of the project to import into}

\item{project_name}{name of the project (for lookup if project_id not provided)}

\item{file_path}{path to the template file (CSV format)}

\item{verbose}{boolean that make the function verbose}

\item{token}{todoist API token}
}
\value{
NULL (invisible)
}
\description{
Import a template into a project
}
\examples{
\dontrun{
import_template(project_name = "my_proj", file_path = "template.csv")
}
}
