% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{tomic_to_matrix}
\alias{tomic_to_matrix}
\title{Tomic To Matrix}
\usage{
tomic_to_matrix(tomic, value_var = NULL, transpose = FALSE)
}
\arguments{
\item{tomic}{Either a \code{tidy_omic} or \code{triple_omic} object}

\item{value_var}{measurement variable to use for the matrix}

\item{transpose}{if TRUE then samples will be stored as rows.
If FALSE (default) then samples will be columns.}
}
\value{
a matrix with features as rows and samples as columns (if transpose
  FALSE) or features as columns and samples as rows (if transpose is TRUE).
}
\description{
Convert a T*Omic object to a feature x sample matrix matching the feature
and sample ordering of a Triple Omic object.
}
\details{
Comparing the matrix to feature or sample variable vectors should
work because the orders are matched. But, if features or samples are reordered
after creating the matrix then the matrix's dimensions will no longer be
aligned to feature and samples.
}
\examples{
tomic_to_matrix(brauer_2008_triple)
}
