/*
 * Decompiled with CFR 0.152.
 */
package jdplus.spreadsheet.base.api;

import ec.util.spreadsheet.Book;
import internal.spreadsheet.base.api.CachedSpreadSheetConnection;
import internal.spreadsheet.base.api.SpreadSheetConnection;
import internal.spreadsheet.base.api.SpreadSheetDataDisplayName;
import internal.spreadsheet.base.api.SpreadSheetParam;
import internal.spreadsheet.base.api.SpreadSheetSupport;
import internal.spreadsheet.base.api.SpreadsheetManager;
import internal.spreadsheet.base.api.grid.SheetGrid;
import internal.spreadsheet.base.api.legacy.LegacySpreadSheetMoniker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import jdplus.spreadsheet.base.api.SpreadSheetBean;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.api.timeseries.TsProvider;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.DataSourceListener;
import jdplus.toolkit.base.tsp.FileLoader;
import jdplus.toolkit.base.tsp.HasDataDisplayName;
import jdplus.toolkit.base.tsp.HasDataMoniker;
import jdplus.toolkit.base.tsp.HasDataSourceBean;
import jdplus.toolkit.base.tsp.HasDataSourceMutableList;
import jdplus.toolkit.base.tsp.HasFilePaths;
import jdplus.toolkit.base.tsp.grid.GridReader;
import jdplus.toolkit.base.tsp.stream.HasTsStream;
import jdplus.toolkit.base.tsp.stream.TsStreamAsProvider;
import jdplus.toolkit.base.tsp.util.DataSetConversion;
import jdplus.toolkit.base.tsp.util.FallbackDataMoniker;
import jdplus.toolkit.base.tsp.util.ResourceFactory;
import jdplus.toolkit.base.tsp.util.ResourcePool;
import jdplus.toolkit.base.tsp.util.ShortLivedCachingLoader;
import lombok.Generated;
import lombok.NonNull;

public final class SpreadSheetProvider
implements FileLoader<SpreadSheetBean> {
    public static final String NAME = "XCLPRVDR";
    private final SpreadsheetManager spreadsheetManager = SpreadsheetManager.ofServiceLoader();
    private final HasDataSourceMutableList mutableListSupport;
    private final HasDataMoniker monikerSupport;
    private final HasDataSourceBean<SpreadSheetBean> beanSupport;
    private final HasFilePaths filePathSupport;
    private final HasDataDisplayName displayNameSupport;
    private final SpreadSheetSupport spreadSheetSupport;
    private final TsProvider tsSupport;

    public SpreadSheetProvider() {
        ResourcePool<SpreadSheetConnection> pool = SpreadSheetSupport.newConnectionPool();
        SpreadSheetParam.V1 param = new SpreadSheetParam.V1();
        this.mutableListSupport = HasDataSourceMutableList.of((String)NAME, arg_0 -> pool.remove(arg_0));
        this.monikerSupport = FallbackDataMoniker.of((HasDataMoniker)HasDataMoniker.usingUri((String)NAME), (HasDataMoniker)LegacySpreadSheetMoniker.of(NAME, param));
        this.beanSupport = HasDataSourceBean.of((String)NAME, (DataSource.Converter)param, (String)param.getVersion());
        this.filePathSupport = HasFilePaths.of(() -> pool.clear());
        this.displayNameSupport = SpreadSheetDataDisplayName.of(NAME, param);
        this.spreadSheetSupport = SpreadSheetSupport.of(NAME, (ResourceFactory<SpreadSheetConnection>)pool.asFactory(dataSource -> SpreadSheetProvider.openConnection(dataSource, this.filePathSupport, param, this.spreadsheetManager)), (DataSetConversion<SpreadSheetConnection, String>)((DataSetConversion)ignore -> param.getSheetParam()), (DataSetConversion<SpreadSheetConnection, String>)((DataSetConversion)ignore -> param.getSeriesParam()));
        this.tsSupport = TsStreamAsProvider.of((String)NAME, (HasTsStream)this.spreadSheetSupport, (HasDataMoniker)this.monikerSupport, () -> pool.clear());
    }

    @NonNull
    public String getDisplayName() {
        return "Spreadsheets";
    }

    @NonNull
    public String getFileDescription() {
        return "Spreadsheet file";
    }

    public boolean accept(File pathname) {
        return this.spreadsheetManager.getReader(pathname).isPresent();
    }

    private static SpreadSheetConnection openConnection(DataSource key, HasFilePaths paths, SpreadSheetParam param, SpreadsheetManager books) throws IOException {
        SpreadSheetBean bean = (SpreadSheetBean)param.get(key);
        File file = paths.resolveFilePath(bean.getFile());
        Book.Factory factory = books.getReader(file).orElseThrow(() -> new IOException("File type not supported"));
        SheetGrid result = SheetGrid.of(file, factory, SpreadSheetProvider.getReader(bean));
        return CachedSpreadSheetConnection.of(result, file, ShortLivedCachingLoader.get());
    }

    private static GridReader getReader(SpreadSheetBean bean) {
        return GridReader.builder().format(bean.getFormat()).gathering(bean.getGathering()).build();
    }

    @Generated
    public boolean open(DataSource arg0) throws IllegalArgumentException {
        return this.mutableListSupport.open(arg0);
    }

    @Generated
    public boolean close(DataSource arg0) throws IllegalArgumentException {
        return this.mutableListSupport.close(arg0);
    }

    @Generated
    public void closeAll() {
        this.mutableListSupport.closeAll();
    }

    @Generated
    public void reload(DataSource arg0) throws IllegalArgumentException {
        this.mutableListSupport.reload(arg0);
    }

    @Generated
    public List<DataSource> getDataSources() {
        return this.mutableListSupport.getDataSources();
    }

    @Generated
    public void addDataSourceListener(DataSourceListener arg0) {
        this.mutableListSupport.addDataSourceListener(arg0);
    }

    @Generated
    public void removeDataSourceListener(DataSourceListener arg0) {
        this.mutableListSupport.removeDataSourceListener(arg0);
    }

    @Generated
    public TsMoniker toMoniker(DataSource arg0) throws IllegalArgumentException {
        return this.monikerSupport.toMoniker(arg0);
    }

    @Generated
    public TsMoniker toMoniker(DataSet arg0) throws IllegalArgumentException {
        return this.monikerSupport.toMoniker(arg0);
    }

    @Generated
    public Optional<DataSource> toDataSource(TsMoniker arg0) throws IllegalArgumentException {
        return this.monikerSupport.toDataSource(arg0);
    }

    @Generated
    public Optional<DataSet> toDataSet(TsMoniker arg0) throws IllegalArgumentException {
        return this.monikerSupport.toDataSet(arg0);
    }

    @Generated
    public SpreadSheetBean newBean() {
        return (SpreadSheetBean)this.beanSupport.newBean();
    }

    @Generated
    public DataSource encodeBean(Object arg0) throws IllegalArgumentException {
        return this.beanSupport.encodeBean(arg0);
    }

    @Generated
    public SpreadSheetBean decodeBean(DataSource arg0) throws IllegalArgumentException {
        return (SpreadSheetBean)this.beanSupport.decodeBean(arg0);
    }

    @Generated
    public void setPaths(File[] arg0) {
        this.filePathSupport.setPaths(arg0);
    }

    @Generated
    public File[] getPaths() {
        return this.filePathSupport.getPaths();
    }

    @Generated
    public File resolveFilePath(File file) throws FileNotFoundException {
        return this.filePathSupport.resolveFilePath(file);
    }

    @Generated
    public String getDisplayName(DataSource arg0) throws IllegalArgumentException {
        return this.displayNameSupport.getDisplayName(arg0);
    }

    @Generated
    public String getDisplayName(DataSet arg0) throws IllegalArgumentException {
        return this.displayNameSupport.getDisplayName(arg0);
    }

    @Generated
    public String getDisplayNodeName(DataSet dataSet) throws IllegalArgumentException {
        return this.displayNameSupport.getDisplayNodeName(dataSet);
    }

    @Generated
    public String getDisplayName(IOException exception) throws IllegalArgumentException {
        return this.displayNameSupport.getDisplayName(exception);
    }

    @Generated
    public List<DataSet> children(DataSource dataSource) throws IllegalArgumentException, IOException {
        return this.spreadSheetSupport.children(dataSource);
    }

    @Generated
    public List<DataSet> children(DataSet parent) throws IllegalArgumentException, IOException {
        return this.spreadSheetSupport.children(parent);
    }

    @Generated
    public void clearCache() {
        this.tsSupport.clearCache();
    }

    @Generated
    public void close() {
        this.tsSupport.close();
    }

    @Generated
    public TsCollection getTsCollection(TsMoniker arg0, TsInformationType arg1) throws IOException, IllegalArgumentException {
        return this.tsSupport.getTsCollection(arg0, arg1);
    }

    @Generated
    public Ts getTs(TsMoniker arg0, TsInformationType arg1) throws IOException, IllegalArgumentException {
        return this.tsSupport.getTs(arg0, arg1);
    }

    @Generated
    public String getSource() {
        return this.tsSupport.getSource();
    }

    @Generated
    public boolean isAvailable() {
        return this.tsSupport.isAvailable();
    }
}

