/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import internal.toolkit.base.tsp.util.FileMapCache;
import internal.toolkit.base.tsp.util.SimpleMapCache;
import java.io.File;
import java.time.Duration;
import jdplus.toolkit.base.tsp.util.ShortLivedCache;
import jdplus.toolkit.base.tsp.util.ShortLivedCaching;
import lombok.NonNull;

public final class CaffeineCaching
implements ShortLivedCaching {
    @NonNull
    private final Ticker ticker;

    public CaffeineCaching() {
        this(Ticker.systemTicker());
    }

    CaffeineCaching(@NonNull Ticker ticker) {
        if (ticker == null) {
            throw new NullPointerException("ticker is marked non-null but is null");
        }
        this.ticker = ticker;
    }

    @Override
    @NonNull
    public String getId() {
        return "caffeine";
    }

    @Override
    @NonNull
    public <K, V> ShortLivedCache<K, V> ofTtl(@NonNull Duration ttl) {
        if (ttl == null) {
            throw new NullPointerException("ttl is marked non-null but is null");
        }
        Cache result = Caffeine.newBuilder().ticker(this.ticker).expireAfterWrite(ttl).softValues().build();
        return new SimpleMapCache(result.asMap());
    }

    @Override
    @NonNull
    public <K, V> ShortLivedCache<K, V> ofFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Cache result = Caffeine.newBuilder().ticker(this.ticker).softValues().build();
        return new FileMapCache(result.asMap(), file);
    }
}

