/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jdplus.toolkit.base.tsp.grid.GridInput;
import lombok.Generated;
import lombok.NonNull;

public class MarkableStream
implements GridInput.Stream {
    @NonNull
    private final GridInput.Stream delegate;
    private final RowBuffer buffer = new RowBuffer();
    private boolean marked = false;

    public void mark() {
        if (this.marked) {
            throw new IllegalStateException();
        }
        this.marked = true;
        this.buffer.moveToFirst();
    }

    public void reset() {
        if (!this.marked) {
            throw new IllegalStateException();
        }
        this.marked = false;
    }

    @Override
    public boolean readRow() throws IOException {
        if (this.marked) {
            if (this.buffer.nextRow()) {
                return true;
            }
            if (this.delegate.readRow()) {
                this.buffer.pushRow(this.readRowToList());
                return true;
            }
            return false;
        }
        return this.buffer.pollRow() || this.delegate.readRow();
    }

    @Override
    public boolean readCell() throws IOException {
        return this.buffer.hasValues() ? this.buffer.nextValue() : this.delegate.readCell();
    }

    @Override
    public Object getCell() throws IOException {
        return this.buffer.hasValues() ? this.buffer.getValue() : this.delegate.getCell();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private List<Object> readRowToList() throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        while (this.delegate.readCell()) {
            result.add(this.delegate.getCell());
        }
        return result;
    }

    @Generated
    public MarkableStream(@NonNull GridInput.Stream delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        this.delegate = delegate;
    }

    private static final class RowBuffer {
        private final LinkedList<List<Object>> availableRows = new LinkedList();
        private int row = -1;
        private int column = -1;
        private List<Object> currentRow = null;

        private RowBuffer() {
        }

        void moveToFirst() {
            this.row = -1;
            this.column = -1;
            this.currentRow = null;
        }

        void pushRow(List<Object> values) {
            this.row = this.availableRows.size();
            this.column = -1;
            this.availableRows.addLast(values);
            this.currentRow = values;
        }

        boolean pollRow() {
            this.row = -1;
            this.column = -1;
            this.currentRow = this.availableRows.pollFirst();
            return this.currentRow != null;
        }

        boolean nextRow() {
            ++this.row;
            this.column = -1;
            if (this.row < this.availableRows.size()) {
                this.currentRow = this.availableRows.get(this.row);
                return true;
            }
            this.currentRow = null;
            return false;
        }

        boolean hasValues() {
            return this.currentRow != null;
        }

        boolean nextValue() {
            ++this.column;
            return this.column < this.currentRow.size();
        }

        Object getValue() {
            return this.currentRow.get(this.column);
        }
    }
}

