% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cascadePlot.R
\name{rowVars}
\alias{rowVars}
\title{Variance of features in rows}
\usage{
rowVars(x, na.rm = TRUE)
}
\arguments{
\item{x}{Numeric matrix}

\item{na.rm}{Logical. Should missing values (including NaN) be omitted from
the calculations?}
}
\value{
A numeric vector of length \code{nrow(x)} with the row-wise variances.
}
\description{
Variance of features in rows
}
\examples{

myVal <- matrix(1:9, nrow=3, byrow=FALSE)
myVar <- rowVars(myVal)
stopifnot(identical(myVar, c(9,9,9)))

}
\keyword{internal}
