% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_helpers.R
\name{summarise_missingness}
\alias{summarise_missingness}
\title{Summarise Missing Data Patterns}
\usage{
summarise_missingness(data, vars)
}
\arguments{
\item{data}{A data.frame containing the analysis dataset with one row per
subject-visit combination.}

\item{vars}{A \code{vars} object as created by \code{\link[rbmi:set_vars]{rbmi::set_vars()}}.}
}
\value{
A list with three components:
\describe{
\item{by_visit}{A tibble with columns: visit, group, n, n_miss, pct_miss}
\item{patterns}{A tibble with columns: subjid, group, pattern
("complete", "monotone", or "intermittent"), dropout_visit (NA if not
monotone)}
\item{summary}{A tibble with columns: group, n_subjects, n_complete,
n_monotone, n_intermittent}
}
}
\description{
Tabulates missing outcome data by visit and treatment group, and classifies
each subject's missing data pattern as complete, monotone, or intermittent.
}
\examples{
library(rbmi)

dat <- data.frame(
  USUBJID = factor(rep(c("S1", "S2", "S3", "S4"), each = 3)),
  AVISIT = factor(rep(c("Week 4", "Week 8", "Week 12"), 4),
                  levels = c("Week 4", "Week 8", "Week 12")),
  TRT = factor(rep(c("Placebo", "Drug A"), each = 6)),
  CHG = c(1, 2, 3, 1, NA, NA, 1, 2, NA, 1, NA, 2)
)

vars <- set_vars(
  subjid = "USUBJID",
  visit = "AVISIT",
  group = "TRT",
  outcome = "CHG"
)

result <- summarise_missingness(dat, vars)
print(result$by_visit)
print(result$patterns)
print(result$summary)

}
\seealso{
\itemize{
\item \code{\link[rbmi:draws]{rbmi::draws()}} for imputation after reviewing missingness patterns
\item \code{\link[=validate_data]{validate_data()}} to check data before imputation
\item \code{\link[=prepare_data_ice]{prepare_data_ice()}} to create intercurrent event data from flags
}
}
