% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.R
\name{describe}
\alias{describe}
\alias{describe-methods}
\alias{describe,data.frame-method}
\alias{describe,blimp_obj-method}
\title{Describe an object}
\usage{
describe(
  object,
  depth = 1,
  pars,
  prob = 0.95,
  digits = 2,
  sort = NULL,
  decreasing = FALSE,
  ...
)

\S4method{describe}{data.frame}(
  object,
  depth = 1,
  pars,
  prob = 0.5,
  digits = 2,
  sort = NULL,
  decreasing = FALSE,
  hist = TRUE,
  ...
)

\S4method{describe}{blimp_obj}(
  object,
  depth = 1,
  pars,
  prob = 0.95,
  digits = 2,
  sort = NULL,
  decreasing = FALSE,
  hist = TRUE,
  ...
)
}
\arguments{
\item{object}{The object to describe.}

\item{depth}{An integer (\code{1}, \code{2}, or \code{3}) that controls the display of vector
and matrix parameters. \code{depth=1} (default) shows only scalar parameters.
\code{depth=2} shows scalars and vectors. \code{depth=3} shows all parameters.}

\item{pars}{An optional character vector of parameter names to include in the summary.}

\item{prob}{The probability mass for the credible interval (e.g., quantile interval).}

\item{digits}{The number of decimal places to display in the output.}

\item{sort}{An optional character string specifying a column name to sort the results by.}

\item{decreasing}{Logical. If \code{TRUE}, sorting is in decreasing order.}

\item{...}{Additional arguments passed to specific methods.}

\item{hist}{Logical. If \code{TRUE} (and on a Unix-like OS), a unicode histogram
(\code{histospark}) is included in the output. Defaults to \code{TRUE}.}
}
\value{
An object of class \linkS4class{describe}, which is a data frame containing
summary statistics and attributes for printing.
}
\description{
\code{describe} provides a flexible summary of various R objects,
such as data frames or Blimp model objects. It is an
alternative to \code{summary} and is inspired by \code{precis} from the \code{rethinking} package.
}
\author{
The \code{data.frame} method is adapted from Richard McElreath's \code{precis}
function in the \code{rethinking} package (\url{https://github.com/rmcelreath/rethinking}).
The \code{histospark} function is by Hadley Wickham (GPL-3).
The \code{blimp_obj} method was written for this package.
}
