% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{sensitivity_analysis}
\alias{sensitivity_analysis}
\title{Run a sensitivity analysis on the error adjustment}
\usage{
sensitivity_analysis(
  parameters,
  data,
  formula,
  columns,
  stan = FALSE,
  seed = 42
)
}
\arguments{
\item{parameters}{list As described above}

\item{data}{data.frame The data to use for the sensitivity analysis}

\item{formula}{character The formula for the model}

\item{columns}{vector The columns within the data for the covariates}

\item{stan}{boolean Whether or not to run with the Stan backend}

\item{seed}{numeric The random seed to set}
}
\value{
list with the means and the SDs of the parameters
}
\description{
Create a sensitivity analysis based on a grid of validity
coefficient parameters. The input of the parameter space
should be a list with each key being the name of one of
the covariates to vary and a vector of the parameter space
to test the sensitivity. Be very careful because all
combinations of the parameters will be tested so you
can very easily run this for too long. Also please note that
the parameters should be be bound between 0 and 1, the
theoretical limits of the validity coefficients. An example of
this parameter grid is:
}
\details{
params <- list(
fruit = c(0.1, 0.2, 0.3),
veg = c(0.1, 0.2, 0.3),
tobacco = c(0.1, 0.2, 0.3)
)

But, again please note that this will then fit 3 * 3 * 3
different models so the run time here can explode. Also
parallel computation will be utilized here, but it is
much more difficult to debug should errors arise. All this to
say is: buyer beware.
}
\examples{
columns <- c("fruit", "veg", "tobacco")
data <- data.frame(
 list(
   "BMI" = rnorm(5, mean = 0, sd = 1),
   "fruit" = rnorm(5, mean = 0, sd = 1),
   "veg" = rnorm(5, mean = 0, sd = 1),
   "tobacco" = rnorm(5, mean = 0, sd = 1)
 )
)
parameters <- list(
  fruit = c(0.3),
  veg = c(0.25),
  tobacco = c(0.4)
)
output_jags <- sensitivity_analysis(
  parameters,
  data,
  "BMI ~ fruit + veg + tobacco",
  columns
)
}
