% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmid_to_ftp.R
\name{pmid_to_ftp}
\alias{pmid_to_ftp}
\title{Convert PubMed IDs (PMIDs) to PMC IDs and Full-Text URLs}
\usage{
pmid_to_ftp(
  pmids,
  batch_size = 200L,
  sleep = 0.5,
  verbose = FALSE,
  ncbi_key = NULL
)
}
\arguments{
\item{pmids}{A character or numeric vector of PubMed IDs (PMIDs) to convert.}

\item{batch_size}{An integer specifying the number of PMIDs to process per
batch for ID conversion. Defaults to 200L. The NCBI API has limitations on batch sizes.}

\item{sleep}{A numeric value specifying the number of seconds to pause
between API requests for ID conversion (Step 1). Defaults to 0.5 seconds.
For OA API calls (Step 2), sleep time is automatically adjusted based on
rate limits: 0.11s with API key (10 req/sec), 0.34s without (3 req/sec).}

\item{verbose}{Logical, whether to print progress messages. Defaults to FALSE.}

\item{ncbi_key}{(Optional) NCBI API key for authenticated access.}
}
\value{
A data.table with columns:
  \itemize{
    \item \code{pmid}: The input PubMed ID
    \item \code{pmcid}: The corresponding PMC ID
    \item \code{doi}: The corresponding DOI (NA if not available)
    \item \code{url}: The full HTTPS URL for downloading PMC full text
  }
  Results are filtered to only include rows with valid URLs (open access articles),
  ordered by PMID. Returns NULL with a message if the API is unavailable or returns invalid data.
}
\description{
This function converts PMIDs to PMC IDs, then fetches the full-text file URLs
from the PMC Open Access service. It combines both steps into a single workflow.
}
\examples{
\donttest{
if (interactive()) {
  # Convert PMIDs to PMC IDs and get full-text URLs
  result <- pmid_to_ftp(c("11250746", "11573492"))
}
}

}
