% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countdata2genobaypass.R
\name{countdata2genobaypass}
\alias{countdata2genobaypass}
\title{Convert a countdata object into BayPass input files.}
\usage{
countdata2genobaypass(
  countdata,
  writing.dir = getwd(),
  prefix = "",
  subsamplesize = -1,
  subsamplingmethod = "thinning"
)
}
\arguments{
\item{countdata}{A countdata object}

\item{writing.dir}{Directory where to create the files  (e.g., set writing.dir=getwd() to copy in the current working directory)}

\item{prefix}{Prefix used for output file names}

\item{subsamplesize}{Size of the sub-samples. If <=1 (default), all the SNPs are considered in the output}

\item{subsamplingmethod}{If sub-sampling is activated (argument subsamplesize), define the method used for subsampling that might be either i) "random" (A single data set consisting of randmly chosen SNPs is generated) or ii) "thinning", sub-samples are generated by taking SNPs one every nsub=floor(nsnp/subsamplesize) in the order of the map (a suffix ".subn" is added to each sub-sample files where n varies from 1 to nsub).}
}
\value{
Files containing allele count (in BayPass format) and SNP details (as in the snp.info matrix from the countdata object)
}
\description{
Convert a countdata object into BayPass allele count file. A file containing SNP details is also printed out. Options to generate sub-samples  (e.g., for large number of SNPs) are also available.
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),poolsizes=rep(50,15))
 ##NOTE: This example is just for the sake of illustration as it amounts to
 ##interpret read count as allele count which must not be done in practice!
 countdata=genobaypass2countdata(genobaypass.file=paste0(tempdir(),"/genobaypass")) 
 countdata2genobaypass(countdata=countdata,writing.dir=tempdir())
}
\seealso{
To generate countdata object, see \code{\link{genotreemix2countdata}}, \code{\link{genobaypass2countdata}}
}
