% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmrm_marginals.R
\name{pmrm_marginals}
\alias{pmrm_marginals}
\title{Marginal means}
\usage{
pmrm_marginals(fit, type = c("outcome", "change", "effect"), confidence = 0.95)
}
\arguments{
\item{fit}{A \code{pmrm} fitted model object returned by a model-fitting
function.}

\item{type}{Character string.
\code{"outcome"} reports marginal means on the outcome scale,
\code{"change"} reports estimates of change from baseline,
and \code{"effect"} reports estimates of treatment effects
(change from baseline of each active arm minus that of the control arm.)}

\item{confidence}{A numeric from 0 to 1 with the confidence level
for confidence intervals.}
}
\value{
A \code{tibble} with one row per marginal mean and columns with the
estimate, standard error, 2-sided confidence bounds, and indicator
columns.
Some estimates, standard errors, and confidence bounds may be \code{NA_real_}
if they correspond to the reference level subtracted out in
change-from-baseline or treatment effect calculations.
}
\description{
Report the estimates and standard errors of marginal means
at each study arm and visit. The assumed visit times should have been
given in the \code{marginals} argument of the model-fitting function.
Use the \code{type} argument to choose
marginal means of the outcomes, marginal estimates of change from
baseline, and marginal estimates of treatment effects.
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  pmrm_marginals(fit)
}
\seealso{
Other estimates: 
\code{\link{VarCorr.pmrm_fit}()},
\code{\link{coef.pmrm_fit}()},
\code{\link{tidy.pmrm_fit}()},
\code{\link{vcov.pmrm_fit}()}
}
\concept{estimates}
