% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pix_fraud_stats.R
\name{get_pix_fraud_stats}
\alias{get_pix_fraud_stats}
\title{Get PIX Fraud Statistics (MED)}
\usage{
get_pix_fraud_stats(
  database,
  filter = NULL,
  columns = NULL,
  top = NULL,
  skip = NULL,
  orderby = NULL,
  verbose = TRUE
)
}
\arguments{
\item{database}{Character string in "YYYYMM" format specifying which month's
data to retrieve. This parameter is \strong{required}.}

\item{filter}{OData filter expression as a character string.}

\item{columns}{Character vector of columns to return. If NULL, returns all
columns.}

\item{top}{Integer; maximum number of records to return.}

\item{skip}{Integer; number of records to skip (for pagination).}

\item{orderby}{Character string specifying the column to sort by. Use
\code{"Column"} for ascending or \code{"Column desc"} for descending order.}

\item{verbose}{Logical; if TRUE (default), prints progress messages.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with PIX fraud statistics.
}
\description{
Retrieves fraud statistics for PIX transactions reported through the
Special Return Mechanism (MED - Mecanismo Especial de Devolução).
}
\details{
The MED (Mecanismo Especial de Devolução) is a mechanism created by the
Brazilian Central Bank to facilitate the return of funds in cases of
fraud or operational errors in PIX transactions.

This endpoint provides statistics on:
\itemize{
\item Number of fraud reports (notificações de infração)
\item Number of return requests (pedidos de devolução)
\item Values involved in fraud cases
}
}
\examples{
\dontrun{# It usually takes much longer than 5 seconds.
# Get fraud statistics for September 2025
fraud <- get_pix_fraud_stats(database = "202509")

# Get top 100 records
fraud <- get_pix_fraud_stats(database = "202509", top = 100)
}
}
