% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeAges.R
\name{imputeUnaffectedAges}
\alias{imputeUnaffectedAges}
\title{Impute Ages for Unaffected Individuals}
\usage{
imputeUnaffectedAges(data, na_indices, empirical_density, max_age)
}
\arguments{
\item{data}{A data frame containing the individual data, including columns for age, sex, and geno.}

\item{na_indices}{A vector of indices indicating the rows in the data where ages need to be imputed.}

\item{empirical_density}{A list of density objects containing the empirical density of ages for different groups.}

\item{max_age}{Integer, the maximum age considered in the analysis.}
}
\value{
The data frame with imputed ages for unaffected individuals.
}
\description{
This function imputes ages for unaffected individuals in a dataset based on their sex
and whether they were tested, using empirical age distributions.
}
