% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R, R/organik.R
\docType{package}
\name{organik}
\alias{organik-package}
\alias{organik}
\title{Multi-Horizon Probabilistic Ensemble with Copulas for Time Series Forecasting}
\usage{
organik(
  ts,
  horizon,
  n_variants = 10,
  engines = c("rpart", "glmnet", "knn"),
  dists = c("gaussian", "laplace", "student", "logistic", "asymmetric_laplace",
    "skew_normal", "skew_t"),
  h_options = c("tree", "ridge"),
  alpha = 1,
  beta = 1,
  temperature = 1,
  dates = NULL,
  ci = 0.95,
  n_testing = 30,
  seed = 42
)
}
\arguments{
\item{ts}{Numeric vector (time series levels).}

\item{horizon}{Integer, number of steps ahead.}

\item{n_variants}{Integer, number of model variants per horizon (ensemble size).}

\item{engines}{Character vector of supported mean-model engines ('rpart', 'glmnet', 'knn').}

\item{dists}{Character vector of supported residual distributions (gaussian, laplace, student, logistic, asymmetric_laplace, skew_normal, skew_t.}

\item{h_options}{Character vector for supported heteroscedastic scale models (tree, ridge).}

\item{alpha, beta}{Numeric weights combining CRPS and calibration error.}

\item{temperature}{Softmax temperature for ensemble weighting (>0).}

\item{dates}{Vector for date formats. Default: NULL.}

\item{ci}{Numeric scalar, confidence interval for plot. Default: 0.9.}

\item{n_testing}{Backtest spacing used inside components.}

\item{seed}{Optional integer seed for reproducibility.}
}
\value{
A list of class `c("organik","list")` with elements:
\itemize{
  \item `model_list`: list of horizon-wise ensemble models.
  \item `growth_pred_funs`: list of marginal predictors for growth.
  \item `level_pred_funs`: list of marginal predictors for level.
  \item `cor_mat`: horizon-by-horizon correlation (after cleaning / nearPD).
  \item `path_prediction(n_paths, probs, copula=c("gaussian","t"), df, return_increments, seed)`:
    function that simulates joint paths and returns summaries (means, quantiles,
    cumulative growth paths, level paths, and incremental returns if requested).
  \item `plot`: plot with prediction in the confidence interval.
}
}
\description{
Trains per-horizon probabilistic ensembles from a univariate time series. It supports 'rpart', 'glmnet', and 'kNN' engines with flexible residual distributions and heteroscedastic scale models, weighting variants by calibration-aware scores. A Gaussian/t copula couples the marginals to simulate joint forecast paths, returning quantiles, means, and step increments across horizons.
}
\examples{
\donttest{
set.seed(1)
y <- cumsum(rnorm(200, sd = 0.5)) + 10
obj <- organik(y, horizon = 4,
  n_variants = 3,
  engines = "knn",
  dists = c("gaussian","laplace"),
  h_options = "tree",
  n_testing = 3, seed = 123)
# joint path simulation for next 4 steps:
path <- obj$path_prediction(n_paths = 100)
str(path$level_quants)
}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/organik}
}

}
\author{
\strong{Maintainer}: Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com} [copyright holder]

}
