% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{v_enum}
\alias{v_enum}
\title{Validator for Enumerated Character Values}
\usage{
v_enum(choices)
}
\arguments{
\item{choices}{A character vector of allowed values.}
}
\value{
A validator function that takes a value \code{x} and raises an error if:
\itemize{
\item \code{x} is not a single character value
\item \code{x} is not in the predefined \code{choices}
}
}
\description{
\code{v_enum()} returns a validator function that checks if a value is a single
character value matching one of a predefined set of choices. This is useful
for options that must be one of several allowed values.
}
\examples{
# Create a validator for one of several color choices
validator <- v_enum(choices = c("red", "green", "blue"))

# Valid inputs
validator("red")
validator("blue")

# Invalid inputs (would raise errors)
try(validator("yellow"))  # not in choices
try(validator(c("red", "blue")))  # vector, not scalar
try(validator(1))  # numeric, not character
}
