% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.admin.R
\name{oadmin.system_perm}
\alias{oadmin.system_perm}
\title{Get the System permissions}
\usage{
oadmin.system_perm(opal)
}
\arguments{
\item{opal}{Opal connection object.}
}
\value{
A data.frame with columns: subject, type, permission
}
\description{
Get the permissions that were applied to the whole system.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
oadmin.system_perm_add(o, c('andrei', 'valentina'), 'user', 'project_add')
oadmin.system_perm(o)
oadmin.system_perm_delete(o, c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
