#' UFO Sightings: Nominal distribution of reported UFO shapes
#'
#' A large real-world dataset of UFO sighting reports collected by the
#' National UFO Reporting Center (NUFORC), a non-profit organization
#' dedicated to the collection and dissemination of objective UFO data.
#'
#' The dataset contains over 63,000 reported sightings spanning several
#' decades and includes information on sighting date, geographic location,
#' duration, narrative comments, and—most importantly for nomiShape—
#' the reported *shape* of the observed object.
#'
#' The \code{shape} variable is a nominal variable with many categories
#' (e.g., "light", "circle", "triangle", "sphere"), exhibiting strong
#' dominance by a few common shapes followed by a gradual decline across
#' rarer categories. Despite the presence of a highly frequent leading
#' category ("light"), the overall frequency structure is better described
#' as triangular or normal-like rather than strictly exponential or Pareto.
#'
#' This dataset is included as a realistic, large-sample example for
#' exploring dominance, modality, and shape classification of nominal
#' distributions using visual and information-theoretic tools.
#'
#' @format A data frame with 63,561 rows and 8 variables:
#' \describe{
#'   \item{date_sighted}{Character. Date of the UFO sighting (YYYY-MM-DD).}
#'   \item{latitude}{Numeric. Latitude of the sighting location.}
#'   \item{longitude}{Numeric. Longitude of the sighting location.}
#'   \item{city}{Character. City where the sighting occurred.}
#'   \item{state}{Character. State or region of the sighting.}
#'   \item{shape}{Character. Reported shape of the UFO (nominal variable of interest).}
#'   \item{duration_sec}{Numeric. Duration of the sighting in seconds.}
#'   \item{comments}{Character. Free-text comments describing the sighting.}
#' }
#'
#' @source
#' National UFO Reporting Center (NUFORC), https://nuforc.org
#'
#' @examples
#' ufo
#'
#' # Centered bar plot highlighting dominance and symmetry
#' centered_barplot(ufo, "shape")
#'
#' # Centered dot plot with connections and shading
#' centered_dotplot(ufo, "shape", connect = TRUE, shade = TRUE)
#'
#' # Shape comparison plot
#' shape_comp_plot(ufo, "shape")
#'
#' # AIC-based shape classification
#' shape_aic(ufo, "shape")
"ufo"
