% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TeamEDGE.R
\name{team_edge_shot_location}
\alias{team_edge_shot_location}
\title{Access the EDGE shot location statistics for a team, season, game type, and
category}
\usage{
team_edge_shot_location(
  team = 1,
  season = "now",
  game_type = "",
  category = "details"
)
}
\arguments{
\item{team}{integer ID (e.g., 21), character full name (e.g., 'Colorado
Avalanche'), OR three-letter code (e.g., 'COL'); see \code{\link[=teams]{teams()}} for
reference; ID is preferable as there now exists duplicate three-letter codes
(i.e., 'UTA' for 'Utah Hockey Club' and 'Utah Mammoth')}

\item{season}{integer in YYYYYYYY (e.g., 20242025); see
\code{\link[=team_edge_seasons]{team_edge_seasons()}} for reference}

\item{game_type}{integer in 1:3 (where 1 = pre-season, 2 = regular season, 3
= playoff/post-season) OR character of 'pre', 'regular', or
'playoff'/'post'; see \code{\link[=team_edge_seasons]{team_edge_seasons()}} for reference; most functions
will NOT support pre-season}

\item{category}{character of 'd'/details' or 't'/'totals'}
}
\value{
data.frame with one row per location (category = 'details') or
combination of strength state and position (category = 'totals')
}
\description{
\code{team_edge_shot_location()} retrieves the EDGE shot location statistics for a team, season, game type, and category as a \code{data.frame} where each row represents location and includes detail on production, workload, efficiency, and result-level performance outcomes plus NHL EDGE style tracking outputs and relative-performance context.
}
\examples{
COL_shot_location_totals_regular_20242025 <- team_edge_shot_location(
  team      = 21,
  season    = 20242025,
  game_type = 2,
  category  = 'T'
)
}
