% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Draft.R
\name{draft_rankings}
\alias{draft_rankings}
\title{Access the draft rankings for a class and category}
\usage{
draft_rankings(class = season_now()\%\%10000, category = 1)
}
\arguments{
\item{class}{integer in YYYY (e.g., 2017); see \code{\link[=drafts]{drafts()}} for reference}

\item{category}{integer in 1:4 (where 1 = North American Skaters,
2 = International Skaters, 3 = North American Goalies, and 4 = International
Goalies) OR character of 'NAS'/'NA Skaters'/'North American Skaters',
'INTLS'/'INTL Skaters'/'International Skaters',
'NAG'/'NA Goalies'/'North American Goalies',
'INTLG'/'INTL Goalies'/'International Goalies'}
}
\value{
data.frame with one row per player
}
\description{
\code{draft_rankings()} scrapes the draft rankings for a given set of \code{class}
and \code{category}.
}
\examples{
draft_rankings_INTL_Skaters_2017 <- draft_rankings(
  class    = 2017, 
  category = 2
)
}
