% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netSEMp2.R
\name{netSEMp2}
\alias{netSEMp2}
\title{network Structural Equation Modelling (netSEM) - Principle 2}
\usage{
netSEMp2(x, exogenous, endogenous, str = FALSE, criterion = "AIC")
}
\arguments{
\item{x}{A dataframe. By default it considers all columns as exogenous variables, except the first column which stores the system endogenous variable.}

\item{exogenous, }{by default it consideres all columns as exogenous variables except column number 1, which is the main endogenous response.}

\item{endogenous}{A character string of the column name of the main endogenous OR a numeric number indexing the column of the main endogenous.}

\item{str}{A boolean, whether or not this is a 'strength' type problem.}

\item{criterion}{By default uses AIC to identify best model. Alternative choice is BIC.}
}
\value{
A list of the following items:

\itemize{
\item "data":
\item "res.print": A dataframe.
\item "res.model": A model object.
}
}
\description{
This function builds an netSEM model using principle 2.
}
\details{
Principle 2 resembles the multiple regression principle in the way multiple predictors are considered simultaneously. Specifically, the first-level predictors to the system level variable, such as, Time and unit level variables, acted on the system level variable collectively by an additive model. This collective additive model can be found with a generalized stepwise variable selection (using the stepAIC() function in R, which performs variable selection on the basis of AIC or BIC) and this proceeds iteratively.

Data is analysed first using Principle 1 to find the best models. If needed, transformations based on the best models are applied to the predictors. Starting from the system response variable, each variable is regressed on all other variables except for the system response in an additive multiple regression model, which is reduced by a stepwise selection using stepAIC(). Then, for each selected variable, fitted regression for 6 selected functional forms (8 if strength type problem) and pick the best.
}
\examples{
\dontrun{
## Load the sample acrylic data set
data(acrylic)

## Using AIC criterion
ans <- netSEMp2(acrylic, "IrradTot", "YI")

## Using BIC criterion
ans <- netSEMp2(acrylic, "IrradTot", "YI", criterion = "BIC")
}
}
\seealso{
\link[netSEM]{netSEMp1}
}
