% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/division_stats.R
\name{division_stats}
\alias{division_stats}
\title{Aggregate player statistics for a NCAA division and seasons}
\usage{
division_stats(
  year = NULL,
  division = 1,
  level = NULL,
  sport = "WVB",
  save = FALSE,
  path = ".",
  delay = 2
)
}
\arguments{
\item{year}{Numeric vector of years for fall of desired seasons.}

\item{division}{NCAA division (must be 1, 2, or 3).}

\item{level}{Character string defining whether to aggregate "teamseason",
"teammatch", "playermatch", or match play-by-play ("pbp") data.}

\item{sport}{Three letter abbreviation for NCAA sport (must be upper case;
for example "WVB" for women's volleyball and "MVB" for men's volleyball).}

\item{save}{Logical for whether to save the statistics locally as CSVs
(default FALSE).}

\item{path}{Character string of path to save statistics files.}

\item{delay}{Numeric for time delay between teams/contests in seconds.}
}
\value{
For season level, returns list with data frames of player statistics and
team statistics. For match and pbp levels, returns data frame of player
statistics and play-by-play information respectively.
}
\description{
This is a wrapper around \code{\link[=group_stats]{group_stats()}} that extracts season, match, or pbp
data from players in all teams in the chosen division. For season stats,
it aggregates all player data and team data into separate data frames and
combines them into a list. For match and pbp stats, it aggregates into a
data frame.
}
\details{
Note: Changes to the NCAA website have made large-scale scraping unstable, and
can trigger IP address blocks when there are lots of requests. This function
seems to trigger these blocks frequently now, so use caution when scraping large
amounts of data.
}
\note{
This function \strong{requires internet connectivity} as it checks the
\href{https://stats.ncaa.org}{NCAA website} for information.
It also uses the \href{https://rstudio.github.io/chromote/}{\code{{chromote}}} package
and \strong{requires \href{https://www.google.com/chrome/}{Google Chrome}} to be
installed.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
division_stats(year = 2024, division = 1, level = "teamseason")
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions that aggregate statistics: 
\code{\link{conference_stats}()},
\code{\link{group_stats}()}
}
\concept{functions that aggregate statistics}
