% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_to_liability.R
\name{binary_to_liability}
\alias{binary_to_liability}
\title{Convert binary traits to liabilities for low prevalence}
\usage{
binary_to_liability(case_control_trait, prevalence)
}
\arguments{
\item{case_control_trait}{Case-control trait encoded as binary trait with 0 as control or 1 as case.}

\item{prevalence}{Case prevalence between 0 and 1. Proportion of cases in the population.}
}
\value{
A trait vector of same length as y with case-control indicators converted
to liabilties.
}
\description{
This function implements an approximate conversion of binary traits to liabilties as
proposed in the LT-MAPIT model (Crawford and Zhou 2018,
https://doi.org/10.1101/374983). Note that this is only good for low prevalence. 
To run LT-MAPIT (MAPIT on case-control traits), convert the binary traits to
liabilities using this function and pass the liabilities to mvmapit as trait.
}
