% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{ncomp}
\alias{ncomp}
\title{Get the number of components}
\usage{
ncomp(x)
}
\arguments{
\item{x}{A fitted model object.}
}
\value{
The number of components in the fitted model.
}
\description{
This function returns the total number of components in the fitted model.
}
\examples{
# Example using the svd_wrapper function
data(iris)
X <- as.matrix(iris[, 1:4])
fit <- svd_wrapper(X, ncomp = 3, preproc = center(), method = "base")
ncomp(fit) # Should return 3
}
