% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapperfunctions.R
\name{geweke.plotTAR}
\alias{geweke.plotTAR}
\title{Geweke-Brooks plot for objects of class \code{mtar}}
\usage{
geweke.plotTAR(
  x,
  frac1 = 0.1,
  frac2 = 0.5,
  nbins = 20,
  pvalue = 0.05,
  auto.layout = TRUE,
  ask,
  ...
)
}
\arguments{
\item{x}{An object of class \code{mtar} returned by a call to \code{mtar()}.}

\item{frac1}{fraction to use from beginning of chain}

\item{frac2}{fraction to use from end of chain}

\item{nbins}{Number of segments}

\item{pvalue}{p-value used to plot confidence limits for the null hypothesis}

\item{auto.layout}{If \code{TRUE} then, set up own layout for plots, otherwise use existing one}

\item{ask}{If \code{TRUE} then prompt user before displaying each page of plots. Default is
\code{dev.interactive()}.}

\item{...}{Additional graphical parameters passed to the plotting routines.}
}
\description{
This function is a wrapper around \code{geweke.plot()} that applies the
Geweke-Brooks convergence diagnostic to the MCMC chains obtained from a
fitted \code{mtar} model.
}
\seealso{
\code{\link[coda]{geweke.plot}}
}
